#pragma once

#include "police/nnlp.hpp"
#include "police/nnlp_marabou.hpp"

namespace police {

class NNLPMarabouPreprocessor final : public NNLP {
public:
    NNLPMarabouPreprocessor(std::shared_ptr<NNLP> sub_nnlp);

    void push_snapshot() final;

    void pop_snapshot() final;

    void clear() final;

    void set_input_index(size_t var, size_t index) final;

    void set_output_index(size_t var, size_t index) final;

    size_t add_variable(const VariableType& var_type) final;

    void set_variable_upper_bound(size_t var_ref, real_t ub) final;

    void set_variable_lower_bound(size_t var_ref, real_t lb) final;

    void add_assumption(const linear_constraint_type& constraint) final;

    void add_constraint(const linear_constraint_type& constraint) final;

    void add_constraint(const relu_constraint_type& constraint) final;

    void add_constraint(const max_constraint_type& constraint) final;

    void
    add_constraint(const linear_constraint_disjunction_type& constraint) final;

    [[nodiscard]]
    Status solve() final;

    [[nodiscard]]
    model_type get_model() const override;

    [[nodiscard]]
    bool has_integer_variable() const final;

    [[nodiscard]]
    size_t num_variables() const final;

    [[nodiscard]]
    real_t get_variable_lower_bound(size_t var_ref) const final;

    [[nodiscard]]
    real_t get_variable_upper_bound(size_t var_ref) const final;

    void dump() const override;

    bool supports_unsolvable_core() const override;

    LinearConstraintConjunction get_unsolvable_core() const override;

    bool preprocess();

private:
    bool add_variable_bounds();

    vector<bool> is_integer_var_;
    vector<linear_constraint_type> assumptions_;
    std::shared_ptr<NNLP> sub_nnlp_;
    std::unique_ptr<MarabouLP> marabou_;
};

} // namespace police
