#pragma once

#include "police/action.hpp"
#include "police/base_types.hpp"
#include "police/storage/unordered_map.hpp"
#include "police/storage/variable_space.hpp"

namespace police {

struct Model {
    void report_infos() const;

    [[nodiscard]]
    vector<Action> determinize() const;

    [[nodiscard]]
    size_t get_label_id(std::string_view label) const;

    [[nodiscard]]
    std::string get_value_name(size_t var, Value value) const;

    VariableSpace variables;
    vector<Action> actions{};
    vector<identifier_name_t> labels{};
    unordered_map<size_t, vector<identifier_name_t>> value_names{};
};

} // namespace police
