#pragma once

#include "police/base_types.hpp"
#include "police/linear_condition.hpp"
#include "police/linear_constraint.hpp"
#include "police/linear_expression.hpp"

namespace police {

class NNLP;

enum class PresolveStatus { SAT, UNSAT, UNKNOWN };

real_t
compute_lb(const NNLP& lp, const LinearCombination<size_t, real_t>& expr);

real_t
compute_ub(const NNLP& lp, const LinearCombination<size_t, real_t>& expr);

PresolveStatus
compare_to_rhs(LinearConstraint::Type type, real_t lb, real_t ub, real_t rhs);

PresolveStatus presolve(const NNLP& lp, const LinearConstraint& constraint);

PresolveStatus presolve(const NNLP& lp, LinearConstraintConjunction& conj);

PresolveStatus presolve(const NNLP& lp, LinearConstraintDisjunction& disj);

PresolveStatus presolve(const NNLP& lp, LinearCondition& cond);

bool encode_linear_condition(NNLP& lp, const LinearCondition& cond);

} // namespace police
