#pragma once

#include "police/nnlp.hpp"

#include <memory>

namespace police {

class NNLPFactory {
public:
    virtual ~NNLPFactory() = default;

    [[nodiscard]]
    std::unique_ptr<NNLP> make_unique() const
    {
        return std::unique_ptr<NNLP>(make());
    }

    [[nodiscard]]
    std::shared_ptr<NNLP> make_shared() const
    {
        return std::shared_ptr<NNLP>(make());
    }

    virtual NNLP* make() const = 0;
};

} // namespace police
