#include "police/relu_constraint.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/variable.hpp"

namespace police {

expressions::Expression ReluConstraint::as_ite_expression() const
{
    expressions::Variable in(x);
    expressions::Variable out(y);
    return expressions::equal(
        out,
        expressions::ite(
            expressions::greater_equal(in, Value(0)),
            in,
            Value(0)));
}

expressions::Expression ReluConstraint::as_max_expression() const
{
    expressions::Variable in(x);
    expressions::Variable out(y);
    return expressions::equal(out, expressions::max(in, Value(0)));
}

} // namespace police
