#pragma once

#include "police/expressions/expression.hpp"
#include "police/model.hpp"
#include "police/verification_property.hpp"
#include <istream>
#include <string_view>

namespace police::sas {

std::pair<Model, VerificationProperty> parse(std::istream& sas);
std::pair<Model, VerificationProperty> parse(std::string_view path);

expressions::Expression
parse_pddl_expression(const Model& model, std::string_view path);

} // namespace police::sas
