#pragma once

#include "police/smt.hpp"

#include <memory>

namespace police {

class SMTFactory {
public:
    virtual ~SMTFactory() = default;

    [[nodiscard]]
    std::unique_ptr<SMT> make_unique() const
    {
        return std::unique_ptr<SMT>(make());
    }

    [[nodiscard]]
    std::shared_ptr<SMT> make_shared() const
    {
        return std::shared_ptr<SMT>(make());
    }

private:
    virtual SMT* make() const = 0;
};

} // namespace police
