#pragma once

#include "police/storage/state_adapter.hpp"
#include "police/storage/value.hpp"
#include "police/storage/value_vector.hpp"

#include <cassert>

namespace police {

namespace detail::flat_state {

class container : private ValueVector {
public:
    using ValueVector::ValueVector;

    constexpr void set(size_t index, const Value& value)
    {
        assert(index < size());
        operator[](index) = (value);
    }

    [[nodiscard]]
    constexpr const Value& get(size_t index) const
    {
        return operator[](index);
    }

    [[nodiscard]]
    constexpr size_t size() const
    {
        return ValueVector::size();
    }

    [[nodiscard]]
    constexpr Value::Type get_type(size_t index) const
    {
        assert(index < size());
        return operator[](index).get_type();
    }

    void push_back(Value value) { ValueVector::push_back(std::move(value)); }
};

} // namespace detail::flat_state

using flat_state = state_adapter<detail::flat_state::container>;

} // namespace police
