#include "police/storage/lin_vector.hpp"

#ifndef POLICE_EIGEN

#include <cassert>

namespace police {

LinVector::LinVector(size_t size)
    : vector<real_t>(size)
{
}

LinVector LinVector::operator+(const LinVector& other) const
{
    assert(size() == other.size());
    LinVector result(*this);
    for (int i = other.size() - 1; i >= 0; --i) {
        result[i] += other[i];
    }
    return result;
}

LinVector LinVector::cwiseMax(const LinVector& other) const
{
    assert(size() == other.size());
    LinVector result(*this);
    for (int i = other.size() - 1; i >= 0; --i) {
        result[i] = std::max(result[i], other[i]);
    }
    return result;
}

void LinVector::setZero()
{
    fill(0);
}

void LinVector::fill(real_t scalar)
{
    std::fill(begin(), end(), scalar);
}

} // namespace police

#endif
