#pragma once

#if POLICE_EIGEN

#include "police/base_types.hpp"

#include <Eigen/Core>

namespace police {

using LinVector = Eigen::Matrix<real_t, Eigen::Dynamic, 1>;

}

#else

#include "police/base_types.hpp"
#include "police/storage/vector.hpp"

#include <cassert>

namespace police {

class LinVector : public vector<real_t> {
public:
    LinVector() = default;

    explicit LinVector(size_t size);

    void setZero();

    void fill(real_t scalar);

    [[nodiscard]]
    const real_t& operator()(size_t idx) const
    {
        return operator[](idx);
    }

    [[nodiscard]]
    real_t& operator()(size_t idx)
    {
        return operator[](idx);
    }

    [[nodiscard]]
    LinVector operator+(const LinVector& other) const;

    [[nodiscard]]
    LinVector cwiseMax(const LinVector& other) const;
};

} // namespace police

#endif
