#pragma once

#include "police/base_types.hpp"

#if POLICE_EIGEN

#include <Eigen/Core>

namespace police {

using Matrix = Eigen::Matrix<real_t, Eigen::Dynamic, Eigen::Dynamic>;

}

#else

#include "police/storage/vector.hpp"

namespace police {

class LinVector;

class Matrix {
public:
    Matrix();

    Matrix(size_t rows, size_t cols);

    void setZero();

    [[nodiscard]]
    size_t cols() const
    {
        return cols_;
    }

    [[nodiscard]]
    size_t rows() const
    {
        return rows_;
    }

    [[nodiscard]]
    const real_t& operator()(size_t row, size_t col) const
    {
        return data_[row * cols_ + col];
    }

    [[nodiscard]]
    real_t& operator()(size_t row, size_t col)
    {
        return data_[row * cols_ + col];
    }

    [[nodiscard]]
    Matrix operator*(const Matrix& matrix) const;

    [[nodiscard]]
    Matrix operator+(const Matrix& matrix) const;

    [[nodiscard]]
    Matrix operator-(const Matrix& matrix) const;

    [[nodiscard]]
    LinVector operator*(const LinVector& vec) const;

    [[nodiscard]]
    Matrix operator*(real_t scalar) const;

    [[nodiscard]]
    Matrix operator/(real_t scalar) const;

    [[nodiscard]]
    Matrix operator-() const;

private:
    vector<real_t> data_;
    size_t cols_;
    size_t rows_;
};

[[nodiscard]]
Matrix operator*(real_t scalar, const Matrix& matrix);

} // namespace police

#endif
