#pragma once

#include "police/storage/state_registry.hpp"

#include <utility>

namespace police::successor_generator {

template <typename SuccessorGenerator, typename _Predicate>
class PruneSuccessors : public SuccessorGenerator {
public:
    using return_type =
        decltype(std::declval<SuccessorGenerator>()(std::declval<FlatState>()));

    PruneSuccessors(
        SuccessorGenerator successor_generator,
        _Predicate predicate)
        : SuccessorGenerator(std::move(successor_generator))
        , predicate_(std::move(predicate))
    {
    }

    template <typename _StateType>
    return_type operator()(const _StateType& state)
    {
        if (!predicate_(state)) {
            return SuccessorGenerator::operator()(state);
        }
        return {};
    }

private:
    _Predicate predicate_;
};

} // namespace police::successor_generator
