#include "police/utils.hpp"

namespace police {

StatePrinter::StatePrinter(const Model* model, const flat_state* state)
    : model(model)
    , state(state)
{
}

std::ostream& operator<<(std::ostream& out, const StatePrinter& printer)
{
    for (size_t var = 0u; var < printer.state->size(); ++var) {
        out << (var > 0u ? " " : "")
            << printer.model->get_value_name(var, (*printer.state)[var]);
    }
    return out;
}

void print_state(std::ostream& out, const Model& model, const flat_state& state)
{
    out << StatePrinter(&model, &state);
}

PlanPrinter::PlanPrinter(const Model* model, const Path* plan)
    : model(model)
    , plan(plan)
{
}

std::ostream& operator<<(std::ostream& out, const PlanPrinter& printer)
{
    for (auto i = 0u; i + 1 < printer.plan->size(); ++i) {
        out << (printer.plan->at(i).label != SILENT_ACTION
                    ? printer.model->labels.at(printer.plan->at(i).label)
                    : "_tau_")
            << "\n";
    }
    return out;
}

void print_plan(std::ostream& out, const Model& model, const Path& plan)
{
    out << PlanPrinter(&model, &plan);
}

PathPrinter::PathPrinter(const Model* model, const Path* plan)
    : model(model)
    , path(plan)
{
}

std::ostream& operator<<(std::ostream& out, const PathPrinter& printer)
{
    for (auto i = 0u; i + 1 < printer.path->size(); ++i) {
        const auto& state = printer.path->at(i).state;
        out << StatePrinter(printer.model, &state) << "\n";
        out << (printer.path->at(i).label != SILENT_ACTION
                    ? printer.model->labels.at(printer.path->at(i).label)
                    : "_tau_")
            << " (" << printer.path->at(i).label << ")\n";
    }
    out << StatePrinter(printer.model, &printer.path->back().state) << "\n";
    return out;
}

void print_path(std::ostream& out, const Model& model, const Path& plan)
{
    out << PathPrinter(&model, &plan);
}

void print_verification_result(
    std::ostream& out,
    const Model& model,
    const std::optional<Path>& plan)
{
    if (plan.has_value()) {
        out << "Plan found.\n";
        out << "Plan length: " << (plan->size() - 1) << "\n";
        print_plan(out, model, plan.value());
        out << "Full path:\n";
        print_path(out, model, plan.value());
        out << std::flush;
    } else {
        out << "Unsolvable." << std::endl;
    }
}

} // namespace police
