#pragma once

#include "police/model.hpp"
#include "police/storage/flat_state.hpp"
#include "police/storage/path.hpp"

#include <optional>
#include <ostream>

namespace police {

struct StatePrinter {
public:
    StatePrinter(const Model* model, const flat_state* state);
    friend std::ostream&
    operator<<(std::ostream& out, const StatePrinter& printer);
    const Model* model;
    const flat_state* state;
};

void print_state(
    std::ostream& out,
    const Model& model,
    const flat_state& state);

struct PlanPrinter {
public:
    PlanPrinter(const Model* model, const Path* plan);
    friend std::ostream&
    operator<<(std::ostream& out, const PlanPrinter& printer);
    const Model* model;
    const Path* plan;
};

void print_plan(std::ostream& out, const Model& model, const Path& plan);

struct PathPrinter {
public:
    PathPrinter(const Model* model, const Path* state);
    friend std::ostream&
    operator<<(std::ostream& out, const PathPrinter& printer);
    const Model* model;
    const Path* path;
};

void print_path(std::ostream& out, const Model& model, const Path& plan);

void print_verification_result(
    std::ostream& out,
    const Model& model,
    const std::optional<Path>& path);

} // namespace police
