#pragma once

#include <iostream>
#include <ranges>
#include <sstream>
#include <string>
#include <utility>

namespace police::ranges {

struct printer {
    explicit printer(std::ostream* out = &std::cout)
        : out(out)
    {
    }

    template <std::ranges::range R>
    std::ostream& operator()(R&& range)
    {
        *out << "[";
        bool sep = false;
        for (auto it = range.begin(); it != range.end(); ++it) {
            *out << (sep ? ", " : "") << *it;
            sep = true;
        }
        *out << "]";
        return *out;
    }

    std::ostream* out;
};

struct stringifier {

    template <std::ranges::range R>
    std::string operator()(R&& range)
    {
        std::ostringstream oss;
        printer p(&oss);
        p(std::forward<R>(range));
        return oss.str();
    }
};

template <std::ranges::range R>
std::string to_string(R&& r)
{
    return stringifier()(std::forward<R>(r));
}

} // namespace police::ranges
