#include "police/utils/rng.hpp"

#include <cassert>
#include <random>

namespace police {

RNG::RNG(int_t seed)
    : gen_(std::make_shared<std::mt19937_64>())
{
    gen_->seed(seed);
}

real_t RNG::operator()() const
{
    std::uniform_real_distribution<> dis(0., 1.);
    return dis(*gen_);
}

int_t RNG::operator()(int_t a, int_t b) const
{
    assert(a <= b);
    std::uniform_int_distribution<> dis(a, b);
    return dis(*gen_);
}

size_t RNG::operator()(size_t last) const
{
    assert(last > 0);
    std::uniform_int_distribution<> dis(0, last);
    return dis(*gen_);
}

} // namespace police
