#include "police/utils/string.hpp"

#include <ranges>

namespace police {

std::string tolower(std::string_view str)
{
    auto tol = [](char c) { return std::tolower(c); };
    auto rng = str | std::ranges::views::transform(tol);
    return std::string(rng.begin(), rng.end());
}

std::string toupper(std::string_view str)
{
    auto tou = [](char c) { return std::toupper(c); };
    auto rng = str | std::ranges::views::transform(tou);
    return std::string(rng.begin(), rng.end());
}

} // namespace police
