#pragma once

namespace police {

template <bool B, typename Then, typename Else>
struct ite;

template <typename Then, typename Else>
struct ite<true, Then, Else> {
    using type = Then;
};

template <typename Then, typename Else>
struct ite<false, Then, Else> {
    using type = Else;
};

template <bool B, typename Then, typename Else>
using ite_t = typename ite<B, Then, Else>::type;

template <bool B, typename T>
using make_const_t = ite_t<B, const T, T>;

} // namespace police
