#include "police/variable_order_chooser.hpp"

#include <algorithm>

namespace police {

VariableOrderChooser::VariableOrderChooser(vector<size_t> ranks)
    : ranks_(std::move(ranks))
{
}

vector<size_t> VariableOrderChooser::get_variable_order() const
{
    vector<size_t> ranks = get_variable_ranks();
    vector<std::pair<size_t, size_t>> aug_ranks;
    aug_ranks.reserve(ranks.size());
    for (size_t var = 0; var < ranks.size(); ++var) {
        aug_ranks.emplace_back(ranks[var], var);
    }
    std::sort(aug_ranks.begin(), aug_ranks.end());
    std::transform(
        aug_ranks.begin(),
        aug_ranks.end(),
        ranks.begin(),
        [](const std::pair<size_t, size_t>& pr) { return pr.second; });
    return ranks;
}

const vector<size_t>& VariableOrderChooser::get_variable_ranks() const
{
    return ranks_;
}

void VariableOrderChooser::set_variable_ranks(vector<size_t> ranks)
{
    ranks_.swap(ranks);
}

} // namespace police
