#pragma once

#include "police/base_types.hpp"
#include "police/storage/vector.hpp"

namespace police {

class VariableOrderChooser {
public:
    VariableOrderChooser() = default;
    explicit VariableOrderChooser(vector<size_t> ranks);
    virtual ~VariableOrderChooser() = default;

    [[nodiscard]]
    vector<size_t> get_variable_order() const;

    [[nodiscard]]
    const vector<size_t>& get_variable_ranks() const;

protected:
    void set_variable_ranks(vector<size_t> ranks);

private:
    vector<size_t> ranks_;
};

} // namespace police
