#pragma once

#include "police/base_types.hpp"
#include "police/linear_condition.hpp"
#include "police/linear_constraint.hpp"
#include "police/storage/vector.hpp"

namespace police {

LinearConstraint
substitute_vars(const LinearConstraint& constraint, const vector<size_t>& vars);

LinearExpression
substitute_vars(const LinearExpression& constraint, const vector<size_t>& vars);

LinearConstraintDisjunction substitute_vars(
    const LinearConstraintDisjunction& constraint,
    const vector<size_t>& vars);

LinearConstraintConjunction substitute_vars(
    const LinearConstraintConjunction& constraint,
    const vector<size_t>& vars);

LinearCondition
substitute_vars(const LinearCondition& constraint, const vector<size_t>& vars);

template <typename T>
std::decay_t<T>
substitute_vars_container(const T& t, const vector<size_t>& vars)
{
    std::decay_t<T> res;
    res.reserve(t.size());
    std::transform(t.begin(), t.end(), std::back_inserter(res), [&](auto&& x) {
        return substitute_vars(x, vars);
    });
    return res;
}

} // namespace police
