#pragma once

#include "police/base_types.hpp"
#include "police/storage/flat_state.hpp"
#include "police/storage/path.hpp"
#include "police/verifiers/ic3/cube.hpp"

#include <concepts>
#include <optional>
#include <utility>

namespace police::ic3::concepts {

template <typename T>
concept StartStateGenerator = requires(T t) {
    { t() } -> std::same_as<std::optional<flat_state>>;
};

template <typename T>
concept FramesInitializer = requires(T t) { t(); };

template <typename T>
concept FrameAdder = requires(T t) {
    { t() } -> std::convertible_to<bool>;
};

template <typename T>
concept FramesChecker = requires(T t, flat_state s, size_t f) {
    { t(s, f) } -> std::convertible_to<bool>;
};

template <typename T>
concept FramesRefiner = requires(T t, flat_state s, size_t f) {
    { t(s, f) } -> std::convertible_to<size_t>;
};

template <typename T>
concept SatInterface =
    requires(T t, const Cube& cube_c, Cube& cube, size_t frame) {
        { t.is_blocked(cube, frame) } -> std::same_as<std::pair<bool, size_t>>;
        t.set_blocked(cube_c, frame);
        t.add_frame();
        t.clear_frames();
    };

template <typename T, typename Sat>
concept ReasonGeneralizer =
    requires(T gen, Sat& sat, Cube& cube, size_t frame) {
        gen(sat, cube, frame);
    };

template <typename T>
concept PathChecker = requires(T t, Path path) {
    { t(path) } -> std::convertible_to<std::optional<size_t>>;
};

} // namespace police::ic3::concepts
