#include "police/verifiers/ic3/cube_utils.hpp"
#include "police/constants.hpp"

#include <algorithm>
#include <cassert>

namespace police::ic3 {

void insert_into_cube(Cube& cube, const LinearConstraint& c)
{
    assert(c.size() == 1u);
    const auto constraint = c.begin()->second < 0. ? -c : c;
    const auto bound = Value(static_cast<int_t>(
        constraint.rhs / constraint.begin()->second + LP_PRECISION));
    auto x = cube.emplace(constraint.begin()->first);
    switch (constraint.type) {
    case LinearConstraint::LESS_EQUAL:
        x.first->second.tighten(Interval::MIN, bound);
        break;
    case LinearConstraint::GREATER_EQUAL:
        x.first->second.tighten(bound, Interval::MAX);
        break;
    case LinearConstraint::EQUAL:
        x.first->second = Interval(bound, bound);
        break;
    }
    assert(cube.has(constraint.begin()->first));
}

void insert_into_cube(Cube& cube, const LinearConstraintConjunction& conj)
{
    std::for_each(conj.begin(), conj.end(), [&](const auto& c) {
        insert_into_cube(cube, c);
    });
}

} // namespace police::ic3
