#pragma once

#include "police/storage/variable_space.hpp"
#include "police/verifiers/ic3/cube.hpp"
#include "police/verifiers/ic3/sat_based/generalizer/utils.hpp"

namespace police::ic3 {

template <typename GoalChecker>
class UnsatCoreGeneralizer {
public:
    UnsatCoreGeneralizer(const VariableSpace* variables, GoalChecker goal)
        : goal_(std::move(goal))
        , variables_(variables)
    {
    }

    template <typename Sat>
    void operator()(Sat&& sat, Cube& reason, size_t frame_id)
    {
        // prepare sat for unsat core extraction
#ifndef NDEBUG
        assert(sat.is_blocked(reason, frame_id).first);
#else
        sat.is_blocked(reason, frame_id);
#endif
        const auto core = sat.get_unsat_core();
        update_from_unsat_core(*variables_, goal_, reason, core);
        assert(sat.is_blocked(reason, frame_id).first);
    }

private:
    GoalChecker goal_;
    const VariableSpace* variables_;
};

} // namespace police::ic3
