#include "police/verifiers/ic3/sat_based/generalizer/utils.hpp"
#include "police/storage/variable_space.hpp"

namespace police::ic3 {

bool is_bounded_int_type(const VariableType& t)
{
    return std::visit(
        [](auto&& t) {
            using T = std::decay_t<decltype(t)>;
            return std::is_same_v<T, BoolType> ||
                   std::is_same_v<T, BoundedIntType>;
        },
        t);
}

Interval get_domain(const VariableType& t)
{
    return Interval(Value(get_lb(t)), Value(get_ub(t)));
}

int_t get_lb(const VariableType& t)
{
    return std::visit(
        [](auto&& t) {
            using T = std::decay_t<decltype(t)>;
            if constexpr (std::is_same_v<T, BoundedIntType>) {
                return t.lower_bound;
            }
            return 0;
        },
        t);
}

int_t get_ub(const VariableType& t)
{
    return std::visit(
        [](auto&& t) {
            using T = std::decay_t<decltype(t)>;
            if constexpr (std::is_same_v<T, BoundedIntType>) {
                return t.upper_bound;
            }
            return 1;
        },
        t);
}

} // namespace police::ic3
