#pragma once

#include "police/storage/variable_space.hpp"
#include "police/verifiers/ic3/cube.hpp"

namespace police::ic3 {

bool is_bounded_int_type(const VariableType& t);

int_t get_lb(const VariableType& t);

int_t get_ub(const VariableType& t);

Interval get_domain(const VariableType& t);

template <typename GoalTest>
void update_from_unsat_core(
    const VariableSpace& variables,
    GoalTest&& goal,
    Cube& reason,
    const Cube& core)
{
    assert(reason <= core);
    Interval domain;
    auto i = reason.begin();
    auto erase = [&]() {
        std::swap(i->second, domain);
        if (goal(reason)) {
            std::swap(i->second, domain);
            ++i;
        } else {
            i = reason.erase(i);
        }
    };
    auto j = core.begin();
    auto e = core.end();
    for (; j != e; ++j) {
        for (; i->first < j->first;) {
            domain = get_domain(variables[i->first].type);
            erase();
        }
        domain = get_domain(variables[j->first].type);
        if (domain <= j->second) {
            erase();
        } else {
            domain.tighten(j->second.lb, j->second.ub);
            std::swap(i->second, domain);
            if (goal(reason)) {
                std::swap(i->second, domain);
            }
            ++i;
        }
    }
    for (; i != reason.end();) {
        domain = get_domain(variables[i->first].type);
        erase();
    }
    // reason.erase(i, reason.end());
}

} // namespace police::ic3
