#pragma once

#include "police/action.hpp"
#include "police/linear_condition.hpp"
#include "police/smt_factory.hpp"
#include "police/encoding_information.hpp"
#include "police/storage/variable_space.hpp"
#include "police/verifiers/ic3/sat_based/sat_interface/smt.hpp"

#include <memory>

namespace police::ic3 {

class IC3SatInterface : public ic3::SatInterfaceSMT {
public:
    [[nodiscard]]
    static IC3SatInterface create(
        const SMTFactory& smt_factory,
        const VariableSpace& vspace,
        vector<Action>::const_iterator first,
        vector<Action>::const_iterator last,
        const vector<LinearConstraintDisjunction>& not_terminal,
        const LinearCondition& goal);

    const std::shared_ptr<SMT>& get_smt() const { return smt_; }

private:
    static EncodingInformation
    initialize(SMT& smt, const VariableSpace& vspace);

    static void add_no_terminals(
        SMT& smt,
        const EncodingInformation& info,
        const vector<LinearConstraintDisjunction>& not_terminal);

    static void add_transitions(
        SMT& smt,
        const EncodingInformation& info,
        vector<Action>::const_iterator first,
        vector<Action>::const_iterator last);

    static void add_goal_frame(
        SMT& smt,
        size_t frame_var,
        const EncodingInformation& info,
        const LinearCondition& goal);

    IC3SatInterface(
        std::shared_ptr<SMT> smt,
        size_t frame_var,
        vector<size_t> in_vars,
        vector<size_t> out_vars);

    std::shared_ptr<SMT> smt_ = nullptr;
};

} // namespace police::ic3
