#pragma once

#include "police/nnlp_factory.hpp"
#include "police/smt_factory.hpp"
#include "police/storage/variable_space.hpp"
#include "police/verifiers/ic3/cube.hpp"
#include "police/verifiers/ic3/sat_based/ic3_engine.hpp"
#include "police/verifiers/ic3/sat_based/ic3_sat.hpp"
#include "police/verifiers/ic3/sat_based/sat_interface/multi_sat.hpp"
#include "police/verifiers/ic3/sat_based/sat_interface/nnlp.hpp"

#include <memory>

namespace police::ic3 {

struct PIC3SatParameters {
    std::shared_ptr<SMTFactory> smt;
    std::shared_ptr<NNLPFactory> nnlp;
    bool app_filter;
    bool determinize;
    bool edge_pruning;
    bool non_policy_prefilter;
};

struct EdgeIndividualSatOption final : public SatInterfaceOption {
    explicit EdgeIndividualSatOption(PIC3SatParameters params)
        : params(std::move(params))
    {
    }

    [[nodiscard]]
    Kind kind() const
    {
        return PER_LABEL;
    }

    PIC3SatParameters params;
};

class PIC3SatEdgeIndividual {
public:
    PIC3SatEdgeIndividual(
        const PIC3SatParameters& params,
        const Model& model,
        const NeuralNetworkPolicy& policy,
        const vector<LinearConstraintDisjunction>& not_terminal,
        const LinearCondition& goal);

    std::pair<bool, size_t> is_blocked(const ic3::Cube& cube, size_t frame);

    void set_blocked(const ic3::Cube& cube, size_t frame);

    void clear_frames();

    void add_frame();

    void dump(std::ostream& out) const;

    ic3::Cube get_unsat_core() const;

private:
    void initialize_sat_silent_edges(
        const SMTFactory& smt_factory,
        const VariableSpace& vspace,
        const vector<LinearConstraintDisjunction>& not_terminal,
        const LinearCondition& goal,
        vector<Action>::const_iterator first,
        vector<Action>::const_iterator last);

    vector<ic3::SatInterfaceNNLP> initialize_sat_policy_edges(
        const NNLPFactory& nnlp_factory,
        const VariableSpace& vspace,
        const vector<LinearConstraintDisjunction>& not_terminal,
        const LinearCondition& goal,
        const NeuralNetworkPolicy& policy,
        vector<Action>::const_iterator first,
        vector<Action>::const_iterator last,
        vector<bool>& pruned,
        bool app_filter,
        bool prune);

    vector<std::shared_ptr<NNLP>> per_edge_nnlp_;
    std::shared_ptr<IC3SatInterface> silent_ = nullptr;
    std::shared_ptr<ic3::MultiSat<ic3::SatInterfaceNNLP>> policy_ = nullptr;
    std::shared_ptr<IC3SatInterface> non_policy_prefilter_ = nullptr;
    bool prefiltered_ = false;
};

} // namespace police::ic3
