#if 0
#include "police/verifiers/ic3/sat_interface/lp.hpp"
#include "police/expressions/linex/linear_constraint.hpp"
#include "police/lp.hpp"

namespace police::ic3 {

namespace {
using expressions::LinearConstraint;
using expressions::LinearConstraintDisjunction;
} // namespace

SatInterfaceLP::SatInterfaceLP(
    LP* base_lp,
    vector<size_t> in_vars,
    vector<size_t> out_vars)
    : input_vars_(std::move(in_vars))
    , output_vars_(std::move(out_vars))
    , frame_var_(base_lp->add_variable(LPVariable(0)))
    , lp_(base_lp)
{
    lp_->push_snapshot();
}

namespace {
LinearConstraint
get_constraint(size_t var_id, real_t bound, LinearConstraint::Type type)
{
    LinearConstraint res(type);
    res.rhs = bound;
    res.insert(var_id, 1);
    return res;
}

LinearConstraint get_lb_constraint(size_t var_id, real_t bound)
{
    return get_constraint(var_id, bound, LinearConstraint::Type::GREATER_EQUAL);
}

LinearConstraint get_ub_constraint(size_t var_id, real_t bound)
{
    return get_constraint(var_id, bound, LinearConstraint::Type::LESS_EQUAL);
}

void enforce_interval(LP* lp, const Interval& iv, size_t var_id)
{
    lp->add_constraint(get_lb_constraint(var_id, iv.lb));
    lp->add_constraint(get_ub_constraint(var_id, iv.ub));
}

void enforce_cube(LP* lp, const Cube& cube, const vector<size_t>& in_vars)
{
    assert(cube.size() == in_vars.size());
    for (size_t i = 0; i < cube.size(); ++i) {
        enforce_interval(lp, cube[i], in_vars[i]);
    }
}

void block_interval(
    LinearConstraintDisjunction& disj,
    const Interval& i,
    size_t out_var)
{
    assert(
        i.lb.get_type() != Value::Type::REAL &&
        i.ub.get_type() != Value::Type::REAL);
    disj.push_back(get_ub_constraint(out_var, static_cast<int_t>(i.lb) - 1));
    disj.push_back(get_lb_constraint(out_var, static_cast<int_t>(i.ub) + 1));
}

LinearConstraintDisjunction
block_cube(const Cube& cube, const vector<size_t>& out_vars)
{
    assert(cube.size() == out_vars.size());
    LinearConstraintDisjunction negation;
    for (size_t i = 0; i < cube.size(); ++i) {
        block_interval(negation, cube[i], out_vars[i]);
    }
    return negation;
}

void block_cube(LP* lp, const Cube& cube, const vector<size_t>& out_vars)
{
    lp->add_constraint(block_cube(cube, out_vars));
}
} // namespace

std::pair<bool, size_t>
SatInterfaceLP::is_blocked(const Cube& cube, size_t frame_id) const
{
    lp_->push_snapshot();
    lp_->add_constraint(get_lb_constraint(frame_var_, frame_id));
    enforce_cube(lp_, cube, input_vars_);
    block_cube(lp_, cube, output_vars_);
    const auto status = lp_->solve();
    lp_->pop_snapshot();
    return {status == LPStatus::INFEASIBLE, frame_id};
}

void SatInterfaceLP::set_blocked(const Cube& cube, size_t frame_id)
{
    auto negation = block_cube(cube, input_vars_);
    negation.push_back(get_ub_constraint(frame_var_, frame_id + 1));
    lp_->add_constraint(negation);
}

void SatInterfaceLP::add_frame()
{
}

void SatInterfaceLP::clear_frames()
{
    lp_->pop_snapshot();
    lp_->push_snapshot();
}

} // namespace police::ic3
#endif
