#include "police/verifiers/ic3/sat_based/sat_interface/multi_sat.hpp"
#include "police/verifiers/ic3/sat_based/sat_interface/nnlp.hpp"

namespace police::ic3 {

std::pair<bool, size_t>
MultiSat<SatInterfaceNNLP>::is_blocked(const Cube& cube, size_t frame)
{
    const auto result = MultiSatBase::is_blocked(cube, frame);
    if (result.first && supports_unsat_core()) {
        unsat_core_.clear();
        for (auto& lp : base_) {
            unsat_core_ &= (lp.get_unsat_core());
        }
    }
    return result;
}

} // namespace police::ic3
