#pragma once

#include "police/base_types.hpp"
#include "police/utils/stopwatch.hpp"
#include <ostream>

namespace police::ic3 {

struct Statistics {
    Statistics();

    void print_status_line(std::ostream& out) const;

    ull_t obligations = 0;
    ull_t rescheduled = 0;
    ull_t clauses = 0;
    ull_t frames = 0;
    ull_t paths = 0;

    StopWatch total_time;
    StopWatch frame_construction_time;
    StopWatch refinement_time;
    StopWatch start_generation_time;
};

} // namespace police::ic3

namespace police {

std::ostream& operator<<(std::ostream& out, const ic3::Statistics& stats);

}
