#include "police/verifiers/ic3/syntactic/applicability_conditioner.hpp"
#include "police/action.hpp"

namespace police::ic3::syntactic {

ApplicabilityInformation::ApplicabilityInformation(
    const Model& model,
    const flat_state& state)
    : var_to_action(model.variables.size())
    , num_applicable_actions(model.labels.size(), 0)
{
    for (size_t i = 0; i < model.actions.size(); ++i) {
        const auto& action = model.actions[i];
        if (action.label == SILENT_ACTION) {
            continue;
        }
        if (action.guard.evaluate(
                [&](size_t var) { return static_cast<real_t>(state[var]); })) {
            for (const auto& constraint : action.guard) {
                for (const auto& [var, coef] : constraint) {
                    if (var_to_action[var].empty() ||
                        var_to_action[var].back() != i) {
                        var_to_action[var].push_back(i);
                    }
                }
            }
            ++num_applicable_actions[action.label];
        }
    }
}

ApplicabilityConditioner::ApplicabilityConditioner(
    const Model& model,
    const ApplicabilityInformation& info)
    : num_applicable_actions_(info.num_applicable_actions)
    , applicable_(model.actions.size(), true)
    , var_to_action_(info.var_to_action)
    , model_(&model)
{
}

bool ApplicabilityConditioner::operator[](size_t label) const
{
    return num_applicable_actions_[label] > 0;
}

void ApplicabilityConditioner::assume_invalid(size_t var)
{
    journal_.clear();
    for (size_t action : var_to_action_[var]) {
        if (applicable_[action]) {
            applicable_[action] = false;
            journal_.push_back(action);
            --num_applicable_actions_[model_->actions[action].label];
        }
    }
}

void ApplicabilityConditioner::revert_last_assumption()
{
    for (const auto& action : journal_) {
        applicable_[action] = true;
        ++num_applicable_actions_[model_->actions[action].label];
    }
}

} // namespace police::ic3::syntactic
