#pragma once

#include "police/model.hpp"
#include "police/storage/flat_state.hpp"
#include "police/storage/vector.hpp"

namespace police::ic3::syntactic {

struct ApplicabilityInformation {
    ApplicabilityInformation() = default;
    ApplicabilityInformation(const Model& model, const flat_state& state);

    vector<vector<size_t>> var_to_action;
    vector<size_t> num_applicable_actions;
};

class ApplicabilityConditioner {
public:
    ApplicabilityConditioner(
        const Model& model,
        const ApplicabilityInformation& info);

    [[nodiscard]]
    bool operator[](size_t label) const;

    void assume_invalid(size_t var);

    void revert_last_assumption();

private:
    vector<size_t> journal_;
    vector<size_t> num_applicable_actions_;
    vector<bool> applicable_;
    const vector<vector<size_t>>& var_to_action_;
    const Model* model_;
};

} // namespace police::ic3::syntactic
