#pragma once

#include "police/verifiers/ic3/syntactic/abstraction.hpp"
#include "police/verifiers/ic3/syntactic/frames_storage.hpp"
#include "police/verifiers/ic3/start_generator.hpp"

namespace police::ic3::syntactic {

class FrameAdder {
public:
    FrameAdder(
        FramesStorage* frames,
        SyntacticAbstraction* abstraction,
        StartGenerator start_generator,
    size_t* cur_frame);

    bool operator()();

private:
    FramesStorage* frames_;
    SyntacticAbstraction* abstraction_;
    StartGenerator start_generator_;
    vector<bool> start_;
    size_t* cur_frame_;
    size_t old_num_cubes_ = 0;
};

} // namespace police::ic3::syntactic
