#include "police/verifiers/ic3/syntactic/frame_refinement_wrapper.hpp"
#include "police/verifiers/ic3/syntactic/frame_refiner.hpp"
#include "police/verifiers/ic3/syntactic/frames_storage.hpp"

namespace police::ic3::syntactic {

FrameRefinementWrapper::FrameRefinementWrapper(
    SyntacticFrameRefiner refiner,
    StartGenerator start_generator,
    const FramesStorage* frames,
    const size_t* cur_frame)
    : syn_frame_refiner_(std::move(refiner))
    , start_generator_(std::move(start_generator))
    , frames_(frames)
    , cur_frame_(cur_frame)
{
}

size_t
FrameRefinementWrapper::operator()(const flat_state& state, size_t target_frame)
{
    const auto cube_id = syn_frame_refiner_.add_reason(state, target_frame);
    const auto frame_index = frames_->get_frame(cube_id);
    if (frame_index >= *cur_frame_) {
        start_generator_.set_blocked(frames_->at(cube_id));
    }
    return std::min(frame_index, *cur_frame_);
}

} // namespace police::ic3::syntactic
