#pragma once

#include "police/verifiers/ic3/syntactic/frame_refiner.hpp"
#include "police/verifiers/ic3/syntactic/frames_storage.hpp"
#include "police/verifiers/ic3/start_generator.hpp"

namespace police::ic3::syntactic {

class FrameRefinementWrapper {
public:
    FrameRefinementWrapper(
        SyntacticFrameRefiner refiner,
        StartGenerator start_generator,
        const FramesStorage* frames,
        const size_t* cur_frame);

    [[nodiscard]]
    size_t operator()(const flat_state& state, size_t target_frame);

    [[nodiscard]]
    const auto& get_statistics() const
    {
        return syn_frame_refiner_.get_statistics();
    }

private:
    SyntacticFrameRefiner syn_frame_refiner_;
    StartGenerator start_generator_;
    const FramesStorage* frames_;
    const size_t* cur_frame_;
};

} // namespace police::ic3::syntactic
