#pragma once

#include "police/storage/vector.hpp"
#include "police/utils/stopwatch.hpp"

namespace police::ic3::syntactic {

struct MinimizationLimits {
public:
    struct MinimizationStep {
        MinimizationStep(double& budget, double limit)
            : time(true)
            , limit(limit)
            , budget(budget)
        {
        }

        ~MinimizationStep() { budget += (limit - time.get_milliseconds()); }

        [[nodiscard]]
        bool out_of_budget() const
        {
            return budget < 0.;
        }

        StopWatch time;
        double limit;
        double& budget;
    };

    MinimizationLimits(
        size_t num_vars,
        double total_time_limit,
        double individual_time_limit)
        : total_limit_(total_time_limit)
        , individual_limit_(individual_time_limit)
        , budget_(num_vars, 0)
    {
    }

    void start() { total_time_.reset(); }

    void end() {}

    [[nodiscard]]
    MinimizationStep step(size_t var)
    {
        return {budget_[var], individual_limit_};
    }

    [[nodiscard]]
    bool out_of_budget() const
    {
        return total_time_.get_milliseconds() > total_limit_;
    }

    [[nodiscard]]
    const StopWatch get_time() const
    {
        return total_time_;
    }

private:
    double total_limit_;
    double individual_limit_;
    vector<double> budget_;
    StopWatch total_time_;
};

} // namespace police::ic3::syntactic
