#include "police/verifiers/ic3/syntactic/policy_reasoner_trivial.hpp"

#include "police/option.hpp"
#include "police/linear_condition.hpp"
#include "police/model.hpp"
#include "police/storage/variable_space.hpp"
#include "police/verifiers/ic3/syntactic/sufficient_condition.hpp"

namespace police::ic3::syntactic {

PolicyReasonerTrivial::PolicyReasonerTrivial(const VariableSpace* variables)
    : variables_(variables)
{
}

SuffCondAlternatives PolicyReasonerTrivial::get_reason(
    const flat_state&,
    const LinearConstraintConjunction&,
    size_t)
{
    SufficientCondition reason;
    for (size_t i = 0; i < variables_->size(); ++i) {
        reason.emplace_back(i, VariableCondition::EQUALITY);
    }
    return {std::move(reason)};
}

namespace {
PointerOption<PolicyReasoner> _opt("disabled", [](const Arguments& args) {
    const auto& model = args.get_model();
    return std::make_shared<PolicyReasonerTrivial>(&model.variables);
});
} // namespace

} // namespace police::ic3::syntactic
