#pragma once

#include "police/linear_condition.hpp"
#include "police/storage/variable_space.hpp"
#include "police/verifiers/ic3/syntactic/policy_reasoner.hpp"

namespace police::ic3::syntactic {

class PolicyReasonerTrivial final : public PolicyReasoner {
public:
    explicit PolicyReasonerTrivial(const VariableSpace* variables);

    [[nodiscard]]
    SuffCondAlternatives get_reason(
        const flat_state& state,
        const LinearConstraintConjunction& guard,
        size_t action) override;

private:
    const VariableSpace* variables_;
};

} // namespace police::ic3::syntactic
