#include "police/verifiers/ic3/syntactic/policy_reasons.hpp"
#include <memory>

namespace police::ic3::syntactic {

PolicyReasons::PolicyReasons(const VariableSpace* variables, size_t num_labels)
    : variables_(variables)
{
    // per_label_.reserve(num_labels);
    for (size_t i = 0; i < num_labels; ++i) {
        per_label_.push_back(
            std::make_unique<FramesStorage>(variables->size()));
    }
}

void PolicyReasons::drop_irrelevant_bounds(Cube& cube) const
{
    size_t j = 0;
    for (size_t i = 0; i < cube.size(); ++i) {
        const auto var = cube[i].first;
        const auto& var_type = variables_->at(var).type;
        Interval val = cube[i].second;
        if (val.lb == var_type.get_lower_bound()) {
            val.lb = Interval::MIN;
        }
        if (val.ub == var_type.get_upper_bound()) {
            val.ub = Interval::MAX;
        }
        if (val.has_lb() || val.has_ub()) {
            cube[j] = {var, val};
            ++j;
        }
    }
    cube.erase(cube.begin() + j, cube.end());
}

void PolicyReasons::block(Cube cube, size_t label)
{
    drop_irrelevant_bounds(cube);
    per_label_[label]->insert(std::move(cube));
}

bool PolicyReasons::is_blocked(const flat_state& state, size_t label) const
{
    bool found = false;
    per_label_[label]->forall_subsumed(state, [&found](size_t) {
        found = true;
    });
    return found;
}

bool PolicyReasons::is_blocked(const Cube& cube, size_t label) const
{
    bool found = false;
    per_label_[label]->forall_subsumed(cube, [&found](size_t) {
        found = true;
    });
    return found;
}

vector<Cube>
PolicyReasons::get_reasons(const flat_state& state, size_t label) const
{
    vector<Cube> result;
    per_label_[label]->forall_subsumed(state, [&](size_t idx) {
        result.push_back(per_label_[label]->at(idx));
    });
    return result;
}

} // namespace police::ic3::syntactic
