#pragma once

#include "police/verification_property.hpp"
#include "police/smt_factory.hpp"
#include "police/storage/variable_space.hpp"

namespace police::ic3::syntactic {

class StartAvoidChecker {
public:
    StartAvoidChecker(
        SMTFactory& smt_factory,
        const VariableSpace& variables,
        const VerificationProperty& property);

    [[nodiscard]]
    bool operator()() const;

private:
    std::unique_ptr<SMT> smt_;
};

} // namespace police::ic3::syntactic
