#include "police/verifiers/ic3/syntactic/sufficient_condition.hpp"
#include "police/macros.hpp"

namespace police {

namespace ic3::syntactic {
VariableCondition::Type VariableCondition::get_type(bool lb, bool ub)
{
    POLICE_ASSERT(lb || ub);
    static Type types[] = {
        VariableCondition::LOWER_BOUND,
        VariableCondition::UPPER_BOUND,
        VariableCondition::EQUALITY,
    };
    return types[static_cast<int>(lb) + 2 * static_cast<int>(ub) - 1];
}

VariableCondition VariableCondition::make(size_t var, bool lb, bool ub)
{
    return {var, get_type(lb, ub)};
}

VariableCondition::VariableCondition(size_t variable, Type type)
    : variable_id(variable)
    , type(type)
{
}

[[nodiscard]]
bool VariableCondition::operator<(const VariableCondition& other) const
{
    return variable_id < other.variable_id ||
           static_cast<int>(type) < static_cast<int>(other.type);
}

[[nodiscard]]
size_t VariableCondition::index() const
{
    return 3 * variable_id + static_cast<int>(type);
}

} // namespace ic3::syntactic

std::ostream&
operator<<(std::ostream& out, const ic3::syntactic::VariableCondition& hs)
{
    out << "{\"var\":" << hs.variable_id << ", \"kind\": "
        << (hs.type == ic3::syntactic::VariableCondition::EQUALITY ? "\"==\""
            : hs.type == ic3::syntactic::VariableCondition::LOWER_BOUND
                ? "\">=\""
                : "\"<=\"")
        << "}";
    return out;
}

} // namespace police
