#pragma once

#include "police/base_types.hpp"
#include "police/storage/vector.hpp"
#include "police/utils/hash.hpp"

#include <iostream>

namespace police::ic3::syntactic {

struct VariableCondition {
    enum Type { LOWER_BOUND = 0, UPPER_BOUND = 1, EQUALITY = 2 };

    VariableCondition(size_t variable, Type type);

    [[nodiscard]]
    static Type get_type(bool lb, bool ub);

    [[nodiscard]]
    static VariableCondition make(size_t var_id, bool lb, bool ub);

    [[nodiscard]]
    bool operator==(const VariableCondition& other) const = default;

    [[nodiscard]]
    bool operator<(const VariableCondition& other) const;

    [[nodiscard]]
    size_t index() const;

    size_t variable_id;
    Type type;
};

using SufficientCondition = vector<VariableCondition>;
using SuffCondAlternatives = vector<SufficientCondition>;

} // namespace police::ic3::syntactic

namespace police {
std::ostream&
operator<<(std::ostream& out, const ic3::syntactic::VariableCondition& hs);

template <>
struct hash<ic3::syntactic::VariableCondition> {
    [[nodiscard]]
    std::size_t operator()(const ic3::syntactic::VariableCondition& cond) const
    {
        return hash_combine(
            get_hash(cond.variable_id),
            get_hash((int)cond.type));
    }
};
} // namespace police
