#pragma once

#include "police/execution_unit.hpp"
#include "police/model.hpp"
#include "police/smt_factory.hpp"
#include "police/verification_property.hpp"
#include "police/verifiers/sampling/sampler.hpp"

namespace police::sampler {

template <typename SuccessorGenerator>
class SamplerUnit final : public ExecutionUnit {
public:
    SamplerUnit(
        const Model& model,
        const VerificationProperty& property,
        const SMTFactory& smt_factory,
        SuccessorGenerator successor_generator,
        size_t num_simulations,
        size_t max_length,
        std::shared_ptr<RNG> rng);

    std::string_view name() const override;
    void run() override;
    void report_result() override;
    void report_statistics() override;

private:
    SuccessorGenerator successor_generator_;
    std::shared_ptr<SMT> initial_states_;
    expressions::Expression avoid_;
    expressions::Expression goal_;
    std::shared_ptr<RNG> rng_;

    size_t num_simulations_;
    size_t max_length_;

    Statistics result_;
};

} // namespace police::sampler
