#pragma once

#include "police/base_types.hpp"
#include "police/execution_unit.hpp"
#include "police/smt_factory.hpp"
#include "police/storage/state_registry.hpp"
#include "police/storage/variable_space.hpp"
#include "police/verification_property.hpp"
#include "police/verifiers/search/path.hpp"

#include <memory>

namespace police::search {

struct SearchConfig {
    enum Variant { BrFS, BFWS, DOT };
    Variant variant = BrFS;
    int width = 2;
    std::shared_ptr<SMTFactory> smt_factory;
    size_t max_states = -1;
};

template <typename _SuccessorGenerator>
class SearchUnit final : public ExecutionUnit {
public:
    SearchUnit(
        SearchConfig config,
        const VariableSpace* variables,
        const vector<identifier_name_t>* labels,
        const VerificationProperty* property,
        std::shared_ptr<StateRegistry> state_registry,
        _SuccessorGenerator succ_gen);

    std::string_view name() const override;
    void run() override;
    void report_result() override;
    void report_statistics() override;

private:
    const VariableSpace* variables_;
    const vector<identifier_name_t>* labels_;
    const VerificationProperty* property_;

    std::shared_ptr<StateRegistry> state_registry_;
    _SuccessorGenerator succ_gen_;

    SearchConfig conf_;

    search::Path counter_example_{};
    bool counter_example_found_ = false;
    size_t state_id_ = -1;
};

} // namespace police::search
