#include "helpers.hpp"
#include "police/expressions/expression.hpp"
#include "police/expressions/identifier_reference.hpp"
#include "police/jani/parser/language.hpp"

namespace police::test {

nlohmann::json make_unary_operation(const std::string& op, nlohmann::json expr)
{
    nlohmann::json obj;
    obj[police::jani::parser::lang::OP] = op;
    obj[police::jani::parser::lang::EXP] = std::move(expr);
    return obj;
}

nlohmann::json
make_operation(const std::string& op, nlohmann::json left, nlohmann::json right)
{
    nlohmann::json obj;
    obj[police::jani::parser::lang::OP] = op;
    obj[police::jani::parser::lang::LEFT] = std::move(left);
    obj[police::jani::parser::lang::RIGHT] = std::move(right);
    return obj;
}

void require_is_identifier(
    const police::expressions::Expression& expr,
    std::string_view identifier)
{
    REQUIRE(expr.is_same(expressions::IdentifierReference(identifier)));
}

} // namespace police::test
