#include "helpers.hpp"
#include "police/jani/parser/language.hpp"
#include "police/jani/parser/types.hpp"

#include <catch2/catch.hpp>
#include <nlohmann/json.hpp>
#include <optional>

namespace {
namespace parser = police::jani::parser;
using json = nlohmann::json;
using namespace police::test;

template <typename T>
T test_type(const json& js)
{
    auto type = parser::type_schema()(js, true);
    REQUIRE(type.has_value());
    return type_cast<T>(type.value());
}

} // namespace

TEST_CASE("Parse bool type", "[jani][parser][types]")
{
    test_type<police::jani::parser::BoolType>(police::jani::parser::lang::BOOL);
}

TEST_CASE("Parse int type", "[jani][parser][types]")
{
    test_type<police::jani::parser::IntegerType>(police::jani::parser::lang::INT);
}

TEST_CASE("Parse real type", "[jani][parser][types]")
{
    test_type<police::jani::parser::RealType>(police::jani::parser::lang::REAL);
}

TEST_CASE("Parse int type (ub)", "[jani][parser][types]")
{
    json js;
    js[police::jani::parser::lang::KIND] = police::jani::parser::lang::BOUNDED;
    js[police::jani::parser::lang::BASE] = police::jani::parser::lang::INT;
    js[police::jani::parser::lang::UPPER_BOUND] = 100;
    auto type = test_type<police::jani::parser::BoundedIntType>(js);
    REQUIRE(!type.lower_bound.has_value());
    REQUIRE(type.upper_bound.has_value());
    require_is_constant(type.upper_bound.value(), 100);
}

TEST_CASE("Parse int type (lb)", "[jani][parser][types]")
{
    json js;
    js[police::jani::parser::lang::KIND] = police::jani::parser::lang::BOUNDED;
    js[police::jani::parser::lang::BASE] = police::jani::parser::lang::INT;
    js[police::jani::parser::lang::LOWER_BOUND] = 10;
    auto type = test_type<police::jani::parser::BoundedIntType>(js);
    REQUIRE(type.lower_bound.has_value());
    REQUIRE(!type.upper_bound.has_value());
    require_is_constant(type.lower_bound.value(), 10);
}

TEST_CASE("Parse int type (lb+ub)", "[jani][parser][types]")
{
    json js;
    js[police::jani::parser::lang::KIND] = police::jani::parser::lang::BOUNDED;
    js[police::jani::parser::lang::BASE] = police::jani::parser::lang::INT;
    js[police::jani::parser::lang::LOWER_BOUND] = 1;
    js[police::jani::parser::lang::UPPER_BOUND] = 100;
    auto type = test_type<police::jani::parser::BoundedIntType>(js);
    REQUIRE(type.lower_bound.has_value());
    REQUIRE(type.upper_bound.has_value());
    require_is_constant(type.lower_bound.value(), 1);
    require_is_constant(type.upper_bound.value(), 100);
}

TEST_CASE("Parse real type (no bounds)", "[jani][parser][types]")
{
    json js;
    js[police::jani::parser::lang::KIND] = police::jani::parser::lang::BOUNDED;
    js[police::jani::parser::lang::BASE] = police::jani::parser::lang::REAL;
    auto type = test_type<police::jani::parser::BoundedRealType>(js);
    REQUIRE(!type.lower_bound.has_value());
    REQUIRE(!type.upper_bound.has_value());
}
