#pragma once

#include <catch2/catch_test_macros.hpp>
#include <cstddef>
#include <type_traits>

struct Self {
    template <typename T>
    [[nodiscard]]
    T operator()(T t) const
    {
        return t;
    }
};

template <size_t Idx, typename Model, typename... Values, typename GetId>
void match_model(
    Model&& model,
    const std::tuple<Values...>& values,
    GetId&& get_id)
{
    if constexpr (Idx < sizeof...(Values)) {
        REQUIRE(
            static_cast<std::remove_cv_t<decltype(std::get<Idx>(values))>>(
                model.get_value(get_id(Idx))) == std::get<Idx>(values));
        match_model<Idx + 1>(
            std::forward<Model>(model),
            values,
            std::forward<GetId>(get_id));
    }
}

template <typename Model, typename... Values>
void match_model(Model&& model, Values&&... values)
{
    std::tuple<Values...> t(std::forward<Values>(values)...);
    match_model<0u>(std::forward<Model>(model), t, Self());
}

template <typename Model, typename... Values, typename GetId>
void match_model_(Model&& model, Values&&... values, GetId&& get_id)
{
    std::tuple<Values...> t(std::forward<Values>(values)...);
    match_model<0u>(std::forward<Model>(model), t, std::forward<GetId>(get_id));
}
