#pragma once

#include "police/storage/ffnn.hpp"
#include "police/utils/rng.hpp"

#include <catch2/catch.hpp>

class FFNNGenerator final
    : public Catch::Generators::IGenerator<police::FeedForwardNeuralNetwork<>> {
public:
    explicit FFNNGenerator(
        size_t input_size,
        size_t output_size,
        size_t hlayers,
        size_t hlayer_size,
        double density,
        int seed = 1734);

    bool next() override;

    [[nodiscard]]
    const police::FeedForwardNeuralNetwork<>& get() const override
    {
        return net_;
    }

    [[nodiscard]]
    police::FeedForwardNeuralNetwork<> generate() const;

    [[nodiscard]]
    police::FeedForwardNeuralNetwork<>::Layer
    generate_layer(size_t in, size_t out) const;

    [[nodiscard]]
    const police::RNG& get_rng() const
    {
        return rng_;
    }

private:
    police::FeedForwardNeuralNetwork<> net_;
    size_t input_size_;
    size_t output_size_;
    size_t hlayers_;
    size_t hlayer_size_;
    double density_;
    police::RNG rng_;
};
