#pragma once

#include "police/base_types.hpp"

#include <catch2/catch.hpp>

#include <cmath>
#include <sstream>

constexpr double PRECISION = 1e-7;

class IsInteger final : public Catch::MatcherBase<police::real_t> {
public:
    bool match(const police::real_t& value) const override
    {
        police::real_t rounded = std::round(value);
        return std::abs(value - rounded) <= PRECISION;
    }

    std::string describe() const override { return "is integer"; }
};

class IsAtLeast final : public Catch::MatcherBase<police::real_t> {
public:
    explicit IsAtLeast(police::real_t lb)
        : lb(lb)
    {
    }

    bool match(const police::real_t& value) const override
    {
        return value + PRECISION >= lb;
    }

    std::string describe() const override
    {
        std::ostringstream s;
        s << "is greater equal " << lb;
        return s.str();
    }

private:
    police::real_t lb;
};

class IsAtMost final : public Catch::MatcherBase<police::real_t> {
public:
    explicit IsAtMost(police::real_t ub)
        : ub(ub)
    {
    }

    bool match(const police::real_t& value) const override
    {
        return value - PRECISION <= ub;
    }

    std::string describe() const override
    {
        std::ostringstream s;
        s << "is less equal " << ub;
        return s.str();
    }

private:
    police::real_t ub;
};
